let userRoute = require("../modules/user/user.route");
let brandRoute = require("../modules/brand/brand.route");
let productRoute = require("../modules/product/product.route");
let clientInquire = require("../modules/clientInquire/clientInquire.route");
let settingRoute = require("../modules/setting/setting.route");

let express = require("express");
let rootRouter = express.Router();

const moduleRoutes = [
  {
    path: "/user",
    route: userRoute,
  },
  {
    path: "/brand",
    route: brandRoute,
  },
  {
    path: "/product",
    route: productRoute,
  },
  {
    path: "/client-inquire",
    route: clientInquire,
  },
  {
    path: "/setting",
    route: settingRoute,
  },
];

moduleRoutes.forEach((route) => rootRouter.use(route.path, route.route));

module.exports = rootRouter;
