const httpStatus = require("http-status");
let User = require("./user.model");
const apiError = require("../../error/apiError");
const { createToken } = require("./user.jwtHelper");

let createUserService = async function (userData) {
  const user = await User.isUserExistsByEmail(userData?.email);

  if (user) {
    throw new apiError(httpStatus.BAD_REQUEST, "User already exist!");
  }

  const newUser = await User.create(userData);

  const { _doc } = newUser;
  const { password, __v, ...restUserData } = _doc;

  return restUserData;
};

const loginUserService = async (payload) => {
  ({ payload });
  const user = await User.isUserExistsByEmail(payload.email);

  if (!user) {
    throw new apiError(httpStatus.BAD_REQUEST, "User not found!");
  }

  if (!(await User.isPasswordMatched(payload?.password, user?.password))) {
    throw new apiError(httpStatus.FORBIDDEN, "Password do not matched");
  }

  const jwtPayload = {
    _id: user?._id,
    userName: user.userName,
    email: user.email,
    role: user.role,
  };

  const accessToken = createToken(
    jwtPayload,
    "agriculture2024@accesstokensecret@12345",
    "1d"
  );

  const refreshToken = createToken(
    jwtPayload,
    "agriculture2024@refreshtokensecret@12345",
    "5d"
  );

  const { _doc } = user;
  const { __v, createdAt, updatedAt, password, ...restData } = _doc;

  return {
    token: {
      accessToken,
      refreshToken,
    },
    userData: restData,
  };
};

const userServices = {
  createUserService,
  loginUserService,
};

module.exports = userServices;
