const httpStatus = require("http-status");
const { createUserService, loginUserService } = require("./user.service");
const catchAsync = require("../../utils/catchAsync");
const sendResponse = require("../../utils/sendResponse");

const createUserController = catchAsync(async (req, res) => {
  const result = await createUserService(req.body);

  sendResponse(res, {
    statusCode: httpStatus.OK,
    success: true,
    message: "User created successfully",
    data: result,
  });
});

const loginUserController = catchAsync(async (req, res) => {
  const result = await loginUserService(req.body);

  sendResponse(res, {
    statusCode: httpStatus.OK,
    success: true,
    message: "User login successful",
    data: result,
  });
});

const userController = {
  createUserController,
  loginUserController,
};

module.exports = userController;
