const Setting = require("./setting.model");

const getSettingService = async () => {
  const settingData = await Setting.findOne({});
  return settingData;
};

const updatePrimitiveSettingServices = async (data) => {
  const result = await Setting.findOneAndUpdate(
    {},

    data,
    {
      new: true,
    }
  );

  return result;
};

const updateAboutUsTitleSettingServices = async (id, title) => {
  const result = await Setting.findByIdAndUpdate(
    id,
    {
      "aboutUS.title": title,
    },
    {
      new: true,
    }
  );

  return result;
};

const addAboutOptionServices = async (option) => {
  const result = await Setting.findOneAndUpdate(
    {},
    {
      $push: {
        "aboutUS.description": [{ option }],
      },
    }
  );

  return result;
};

const deleteAboutOptionServices = async (optionId) => {
  const result = await Setting.findOneAndUpdate(
    {},
    {
      $pull: {
        "aboutUS.description": { _id: optionId },
      },
    }
  );

  return result;
};

const settingServices = {
  getSettingService,
  updatePrimitiveSettingServices,
  updateAboutUsTitleSettingServices,
  addAboutOptionServices,
  deleteAboutOptionServices,
};

module.exports = settingServices;
