let express = require("express");
let settingRoute = express.Router();

const {
  getSettingController,
  updatePrimitiveSettingController,
  updateAboutUsTitleSettingController,
  addAboutOptionController,
  deleteAboutOptionController,
} = require("./setting.controller");

settingRoute.route("/").get(getSettingController);

settingRoute
  .route("/primitive/:settingId")
  .patch(updatePrimitiveSettingController);

settingRoute
  .route("/about-us/title/:settingId")
  .patch(updateAboutUsTitleSettingController);

settingRoute.route("/about-us/option/add").patch(addAboutOptionController);

settingRoute
  .route("/about-us/option/delete/:optionId")
  .patch(deleteAboutOptionController);

module.exports = settingRoute;
