const httpStatus = require("http-status");
const catchAsync = require("../../utils/catchAsync");
const sendResponse = require("../../utils/sendResponse");

const {
  getSettingService,
  updatePrimitiveSettingServices,
  updateAboutUsTitleSettingServices,
  addAboutOptionServices,
  deleteAboutOptionServices,
} = require("./setting.service");

const getSettingController = catchAsync(async (req, res) => {
  const result = await getSettingService();

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "get Setting succesfully",
    data: result,
  });
});

const updatePrimitiveSettingController = catchAsync(async (req, res) => {
  const data = req.body;

  const result = await updatePrimitiveSettingServices(data);

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "Update Setting   succesfully",
    data: result,
  });
});

const updateAboutUsTitleSettingController = catchAsync(async (req, res) => {
  const { settingId } = req.params;

  const { title } = req.body;
  const result = await updateAboutUsTitleSettingServices(settingId, title);

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "Update Setting   succesfully",
    data: result,
  });
});

const addAboutOptionController = catchAsync(async (req, res) => {
  const { option } = req.body;

  const result = await addAboutOptionServices(option);

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "Delete aboutUs option  succesfully",
    data: result,
  });
});

const deleteAboutOptionController = catchAsync(async (req, res) => {
  const { optionId } = req.params;

  const result = await deleteAboutOptionServices(optionId);

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "Delete aboutUs option  succesfully",
    data: result,
  });
});

const settingController = {
  getSettingController,
  updatePrimitiveSettingController,
  updateAboutUsTitleSettingController,
  addAboutOptionController,
  deleteAboutOptionController,
};

module.exports = settingController;
