const Product = require("./product.model");

const createProductService = async (payload) => {
  // console.log({ payload });
  const result = await Product.create(payload);

  return result;
};

const getAllProductService = async () => {
  const allData = await Product.find({}).sort({
    createdAt: -1,
  });

  return allData;
};

const deleteProductService = async (id) => {
  console.log({ id });
  const result = await Product.findByIdAndDelete(id);
  return result;
};

const productServices = {
  createProductService,
  getAllProductService,
  deleteProductService,
};

module.exports = productServices;
