const mongoose = require("mongoose");
const { Schema } = mongoose;

const tableFieldSchema = new Schema({
  fieldName: {
    type: String,
    required: true,
  },
  fieldValue: {
    type: String,
    required: true,
  },
});

const productSchema = new Schema(
  {
    name: {
      type: String,
      required: true,
    },
    brand: {
      type: String,
      required: true,
    },
    category: {
      type: String,
      required: true,
    },
    description: {
      type: String,
    },
    imageUrl: {
      type: String,
      required: true,
    },
    iframeString: {
      type: String,
    },
    purchaseLink: {
      type: String,
    },
    tableFields: [tableFieldSchema],
  },
  {
    timestamps: true,
  }
);

const Product = mongoose.model("Product", productSchema);

module.exports = Product;
