const httpStatus = require("http-status");
const catchAsync = require("../../utils/catchAsync");
const sendResponse = require("../../utils/sendResponse");

const {
  createProductService,
  getAllProductService,
  deleteProductService,
} = require("./product.service");

const createProductController = catchAsync(async (req, res) => {
  const result = await createProductService(req.body);

  sendResponse(res, {
    statusCode: httpStatus.OK,
    success: true,
    message: "Product created successfully",
    data: result,
  });
});

const getAllProductController = catchAsync(async (req, res) => {
  const result = await getAllProductService();

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "Get all products data succesfully",
    data: result,
  });
});

const deleteProductController = catchAsync(async (req, res) => {
  const { id } = req.params;

  console.log(req.body);

  const result = await deleteProductService(id);

  sendResponse(res, {
    statusCode: httpStatus.OK,
    success: true,
    message: "Delete product succesfully",
    data: result,
  });
});

const productController = {
  createProductController,
  getAllProductController,
  deleteProductController,
};

module.exports = productController;
