const ClientInquire = require("./clientInquire.model");

const createClientInquireService = async (payload) => {
  // console.log({ payload });
  const result = await ClientInquire.create(payload);

  return result;
};

const getAllInquireService = async () => {
  const allData = await ClientInquire.find({}).sort({
    createdAt: -1,
  });

  return allData;
};

const updateStatusInquireServices = async (id) => {
  const newCountry = await ClientInquire.findByIdAndUpdate(id, {
    status: "done",
  });

  return newCountry;
};

const clientInquireServices = {
  createClientInquireService,
  getAllInquireService,
  updateStatusInquireServices,
};

module.exports = clientInquireServices;
