const mongoose = require("mongoose");
const { Schema } = mongoose;

const clientInquireSchema = new Schema({
  fullName: {
    type: String,
    required: true,
    trim: true,
  },
  email: {
    type: String,
    required: true,
    trim: true,
    lowercase: true,
  },
  phone: {
    type: String,
    required: true,
  },
  comments: {
    type: String,
    default: "",
  },
  status: {
    type: String,
    enum: ["pending", "done"],
    default: "pending",
  },
  apartmentId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "Apartment",
  },
});

const ClientInquire = mongoose.model("clientInquire", clientInquireSchema);

module.exports = ClientInquire;
