const httpStatus = require("http-status");
const catchAsync = require("../../utils/catchAsync");
const sendResponse = require("../../utils/sendResponse");

const {
  createClientInquireService,
  getAllInquireService,
  updateStatusInquireServices,
} = require("./clientInquire.service");

const createClientInquireController = catchAsync(async (req, res) => {
  const result = await createClientInquireService(req.body);

  sendResponse(res, {
    statusCode: httpStatus.OK,
    success: true,
    message: "Client  Inquire added successfully",
    data: result,
  });
});

const getAllClientInquireController = catchAsync(async (req, res) => {
  const result = await getAllInquireService();

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "Get all Inquire data  ",
    data: result,
  });
});

const deleteClientInquireController = catchAsync(async (req, res) => {
  const { id } = req.params;

  console.log(req.body);

  const result = await updateStatusInquireServices(id);

  sendResponse(res, {
    statusCode: httpStatus.OK,
    success: true,
    message: "Delete product succesfully",
    data: result,
  });
});

const updateStatusInquireController = catchAsync(async (req, res) => {
  const { inqureId } = req.params;

  const result = await updateStatusInquireServices(inqureId);

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "update Inquire  succesfully",
    data: result,
  });
});

const clientInquireController = {
  createClientInquireController,
  getAllClientInquireController,
  updateStatusInquireController,
};

module.exports = clientInquireController;
