const Brand = require("./brand.model");

const createBrandService = async (payload) => {
  // console.log({ payload });
  const result = await Brand.create(payload);

  return result;
};

const getAllBrandsService = async () => {
  const allData = await Brand.find({}).sort({
    name: 1,
  });

  return allData;
};

const deleteBrandService = async (id) => {
  const result = await Brand.findByIdAndDelete(id);
  return result;
};

const brandServices = {
  createBrandService,
  getAllBrandsService,
  deleteBrandService,
};

module.exports = brandServices;
