const mongoose = require("mongoose");
const { Schema, model, Types } = mongoose;
const apiError = require("../../error/apiError");
const httpStatus = require("http-status");
 

const brandSchema = new Schema(
  {
    name: {
      type: String,
      unique: true,
      required: true,
    },
    image: {
      type: String,
      required: true,
    },
    role: {
      type: String,
      enum: ["brand", "category"],
      default: "brand",
    },
  },
  {
    timestamps: true,
  }
);

// Static Method
brandSchema.statics.isBrandExists = async function (id) {
  const isExists = await this.findById(id);

  if (!isExists) {
    throw new apiError(httpStatus.NOT_FOUND, `${id} is not a valid ID`);
  }
};

// Export Model
const Brand = model("Brand", brandSchema);

module.exports = Brand;
