const httpStatus = require("http-status");
const {
  createBrandService,
  getAllBrandsService,
  deleteBrandService,
} = require("./brand.service");
const catchAsync = require("../../utils/catchAsync");
const sendResponse = require("../../utils/sendResponse");

const createBrandController = catchAsync(async (req, res) => {
  const result = await createBrandService(req.body);

  sendResponse(res, {
    statusCode: httpStatus.OK,
    success: true,
    message: "Brand created successfully",
    data: result,
  });
});

const getAllBrandController = catchAsync(async (req, res) => {
  const result = await getAllBrandsService();

  sendResponse(res, {
    statusCode: httpStatus.CREATED,
    success: true,
    message: "Get all brands data succesfully",
    data: result,
  });
});

const deleteBrandController = catchAsync(async (req, res) => {
  const { id } = req.params;

  console.log(req.body);

  const result = await deleteBrandService(id);

  sendResponse(res, {
    statusCode: httpStatus.OK,
    success: true,
    message: "Delete brand succesfully",
    data: result,
  });
});

const brandController = {
  createBrandController,
  getAllBrandController,
  deleteBrandController,
};

module.exports = brandController;
