const express = require("express");
const cors = require("cors");
const httpStatus = require("http-status");

let rootRouter = require("./routes/index");

const globalErrorHandler = require("./middleware/globalErrorHandler.js");
const errorResponse = require("./utils/errorResnponse");

let app = express();

app.use(express.json());
app.use(cors());

app.use("/api/v1", rootRouter);

app.get("/", function (req, res) {
  res.send("Route is working! Agriculture Project!");
});

app.all("*", function (req, res) {
  res
    .status(httpStatus.NOT_FOUND)
    .json(errorResponse(httpStatus.NOT_FOUND, "failed", "api not found"));
});

app.use(globalErrorHandler);

module.exports = app;
